######################### Basic Mathematics #############################

########################################## Setzen der 'Working Directory'
setwd("D:/AS17 translation/AS17 supplements")

#########################################################################

#########################################################################

                                                           # Section 2.3

12 + 32                                    # Addition
43 - 15                                    # Subtraction

numbers <- c(2, 5, 7, 8, 9, 6)             # Values in vectors
sum(numbers)                               # Sum

#########################################################################

1:20                                       # Sequence
sum(1:20)                                  # Sum

#########################################################################

4 * 17                                     # Multiplication
56 / 8                                     # Division
numbers <- c(2, 3, 4,5)
prod(numbers)                              # Product
1:10
prod(1:10)                                 # Factorial

#########################################################################

                                           # Greatest Common Divisor
GCD <- function(m, n) ifelse (n==0, m, GCD(n, m %% n))
GCD(21, 35) 

                                           # Least Common Multiple 
LCM <- function(m, n) abs(m*n) / GCD(m, n)
LCM(21, 35)

GCD(3528, 3780); LCM(3528, 3780)

#########################################################################

2^4                                         # Exponentiation
12^4

#########################################################################

sqrt(3)                                     # Radicalizing
sqrt(234)
35^(5/3)

#########################################################################

pi                                        # Pi = 3.141593
exp(1)                                    # e = 2.718282
log(12, base = exp(1))                    # Logarithm to the base e
log10(16)                                 # Logarithm to the base 10
log2(20)                                  # Logarithm to the base 2

#########################################################################
                                         
x <- c(1.347, 2.499, 3.501)               # Rounding
floor(x)
ceiling(x)

#########################################################################

x <- c(1.347, 2.499, 3.501)
floor(x + 0.5)
x <- c(-1.347, -2.499, -3.501)
ceiling(x - 0.5)

#########################################################################

rounding <- function(x, m) floor((x/m + 0.5))*m 
rounding(x=1.3567, m=c(0.1, 0.01, 0.001, 0.25, 0.5))

#########################################################################

x <- seq(1.1, 1.4, 0.02)                   # examples table 2.4
y <- rounding(x, m=0.1)
z <- rounding(x, m=0.25)
rbind(x,y,z)

#########################################################################

round(x=1.3567, digits=c(1,2,3)) 

#########################################################################

                                                            # Section 2.4
library(Matrix)
library(MASS)

A <- matrix( c(1, 2, 3, 6, 5, 4), nrow=2, ncol=3, byrow=TRUE)
A.trans <- t(A); A; A.trans              # Transposing a matrix

#########################################################################
                                          
A <- matrix( c(1, 2, 3, 6, 5, 4), nrow=2, ncol=3, byrow=TRUE)
B <- matrix(c(4, 5, 6, 9, 8, 7), nrow=2, ncol=3, byrow=TRUE) 
C <- A + B; A; B; C                     # Addition of matrices                              

#########################################################################

A <- matrix( c(1, 2, 3, 6, 5, 4), nrow=2, ncol=3, byrow=TRUE); 
A; 2 * A                                # Multiplication with scalar                           

#########################################################################

A <- matrix( c(1, 2, 3, 6, 5, 4), nrow=2, ncol=3, byrow=TRUE); 
B <- matrix(c(4, 5, 6, 9, 8, 7), nrow=3, ncol=2, byrow=TRUE);
C <- A %*% B; A; B; C                   # Multiplication of matrices                    

#########################################################################
                                        
a <- 1:3                                
b <- 4:6
c <- t(a) %*% b; a; b; c                # Scalar product of vectors                       

#########################################################################
                                                     
a <- c(1, 2, 3, 4, 5, 6)                
a.trans <- t(a)
a.norm <- sqrt(a.trans %*% a)           # Norm of a vector                                      
a; a.norm

#########################################################################
                                            
A     <- matrix(c(3, 1, 2, 4, 5, 6, 9, 7, 8), nrow=3, ncol=3, byrow=TRUE)
A.det <- det(A); A; A.det              # Determinant of a matrix                       

#########################################################################
                                         
A     <- matrix(c(3, 1, 2, 4, 5, 6, 9, 7, 8), nrow=3, ncol=3, byrow=TRUE)
A.inv <- solve(A)                      # Inverse of a matrix                        
A; round(A.inv, 2); round(A %*% A.inv, 2)

library(MASS)                          # with ginv() from library(MASS)
A.inv <- ginv(A)                       
A; round(A.inv, 2); round(A %*% A.inv, 2)

#########################################################################

                                                       # Linear Equations

A     <- matrix(c(3, 1, 2, 4, 5, 6, 9, 7, 8), nrow=3, ncol=3, byrow=TRUE)
b     <- c(2,4,8); A; b
x     <- solve(A, b); round(x, 2)      # OLS Solution   
A %*% x                                # Check

#########################################################################
                                       
A     <- matrix(c(3, 1, 2, 4), nrow = 2, ncol=2, byrow=TRUE);A
l     <- eigen(A)$values; round(l, 2)    # Eigenvalues in A                       
x     <- eigen(A)$vectors; round(x, 2)   # Eigenvectors in A                   

#########################################################################

                                                          # Abschnitt 2.5

                                                          # Figure 2.6
par(mfrow=c(1,1), font.axis=2, bty="l", ps=12, cex.axis=1.0) 
x   <- seq(-1.9, +1.9, by=0.02)
y.1 <- 2 + 3 * x
y.2 <- 5 - 2 * x
plot(x, y.1, type="l", axes=F, xlab="", ylab="", las=1, lwd=1.9,
     xlim=c(-2, +2), ylim=c(-4,9))
axis(side = 1, pos = 0, xaxp=c(-2, 2, 8))
axis(side = 2, pos = 0, las=1)
lines(x, y.2, lwd=1.9)
points(0.6, 3.8, pch=16, cex=1.3)
text(1.2, 7.5, expression("f(x)=2+3x"), cex=1.2)
text(-1.3, 6, expression("g(x)=5-2x"), cex=1.2)
text(0.7, 1.1, "intersection point: (0.6, 3.8)", cex=1.2)

#########################################################################

                                                            # Figure 2.7
par(mfrow=c(1,1), font.axis=2, bty="l", ps=12, cex.axis=1.0) 
x <- seq(-2, +2, by=0.02)
y.1 <-  1 - 2*x + 3*x^2
y.2 <-  4 + 5*x - 3*x^2
plot(x, y.1, type="l", axes=F, xlab="", ylab="", las=1, lwd=1.9,
     xlim=c(-2, +2), ylim=c(-6, +6))
axis(side = 1, pos = 0, xaxp=c(-2, 2, 8))
axis(side = 2, pos = 0, las=1)
lines(x, y.2, lwd=1.9)
text(-1.3, 4.0, expression(f(x) == 1 - 2*x + 3*x^2), cex=1.2)
text(-1.5, -4.0, expression(g(x)==4 + 5*x - 3*x^2), cex=1.2)
points(-(-2/(2*3)),    1-((-2)^2 /   (4*3)), pch=19, cex=1.5)
points(-(5 /(2*(-3))), 4-( 5^2   /(4*(-3))), pch=19, cex=1.5)

#########################################################################

                                                             # Figure 2.8
par(mfrow=c(1,2), font.axis=2, bty="l", ps=12, cex.axis=1.0) 
x <- seq(-1.0, + 1.0, by=0.0002)
y <- sqrt(1-x^2)
plot(c(x, x, 1), c(y, -y, 0), type="l", axes=FALSE, xlab="", ylab="",
     las=1, xlim=c(-1.2, +1.2), ylim=c(-1.2, +1.2)) 
text(0.2,0.091, expression(x), cex=1.0)
lines(c(0.0, 0.0), c(-1,+1)); lines(c(-1,+1),    c(0,0))
lines(c(0.0, 1.2), c(0.0, 1.0));   lines(c(0.0, 1.2), c(1.0, 1.0))
lines(c(1.0, 1.0), c(0.0, 0.822)); lines(c(0.77, 0.77), c(0.0, 0.65))

text(-0.06, -0.08, "0", cex=1.2, font=2)
text(1.06, -0.08, "A", cex=1.2, font=2)
text(0.78, -0.08, "B", cex=1.2, font=2)
text(0.78, +0.75, "C", cex=1.2, font=2)
text(1.08, +0.78, "D", cex=1.2, font=2)
text(0.06, +1.1, "E", cex=1.2, font=2)
text(1.21, +1.1, "F", cex=1.2, font=2)

x <- seq(0, 2*pi, by=0.01)
y.1 <- cos(x);  y.2 <- sin(x)
plot(x, y.1, type="l", axes=F, xlab="", ylab="", lwd=2.0,
     xlim=c(0, 2*pi), xaxp=c(0, 2*pi, 5), ylim=c(-1, +1))
axis(side=2, pos = 0, yaxp=c(-1, 1, 10), las=1, cex=1.0)                   
axis(side=1, pos = -1.0, at=c(0, pi/2, pi, 3*pi/2, 2*pi), 
     labels=expression(0, pi/2, pi, 3*pi/2, 2*pi), cex=2.0) 
lines(x, y.2, lwd=2.0)
text(3.4, 0.8, expression(sin(x)), cex=1.2)
text(1.2, -0.8, expression(cos(x)), cex=1.2)
abline(h=0)

#########################################################################

                                                             # Figure 2.9

par(mfrow=c(1,3), lwd=2.0, font.axis=2, bty="l", ps=12, cex.axis=1.5) 
x <- seq(-2, 3, by=0.001)
y.1 <- exp(x)
y.2 <- (1/5)^x
plot(x, y.1, type="l", axes=TRUE, xlab="", ylab="", las=1,
     xlim=c(-3, 3), ylim=c(0, 20))
lines(x, y.2)
text(2, 19, expression(y==e^x), cex=2.5)
text(-2.2, 4, expression(y==0.2^x) , cex=2.0)

x <- seq(0, 10, by=0.001)
y.1 <- log(x)
y.2 <- log10(x)
plot(x, y.1, type="l", axes=TRUE, xlab="", ylab="", las=1,
     xlim=c(0, 10), ylim=c(-4,4))
lines(x, y.2)
text(4, 2, expression(y==ln(x)), cex=2.0)
text(8, 1.3, expression(y==lg(x)), cex=2.0)

x <- seq(-3, 3, by=0.001)
y <- exp(-0.5*x^2)
plot(x, y, type="l", axes=TRUE, xlab="", ylab="", las=1,
     xlim=c(-3, 3), ylim=c(0, 1))
text(2.0, 0.9, expression(y == e^-(frac(1,2)*x)^2), cex=2.5)

######################################################################### 

                                                            # Figure 2.10

par(mfrow=c(1,3), lwd=2, font.axis=2, bty="l", ps=15, cex.axis=1.5) 
                                    # constant grows
e <- exp(1); t <- seq(0, 20, by=0.1); lambda <- 0.1;  N.0 <- 10
N <- N.0 * e^(lambda*t)
plot(t, N, ylim=c(0,100), type="l", las=1, cex.lab=1.5,
     xlab="time [t]", ylab="stock [N]")
abline(h=10, lty=2); text(10, 100, "A", cex=2)
                                    # grows with saturation
N.max  <- 90; lambda <- -0.2; N.0    <- 10
N <- N.max - (N.max-N.0)*e^(lambda*t)
plot(t, N, ylim=c(0,100), type="l", las=1, cex.lab=1.5,
     xlab="time [t]", ylab="stock [N]")
abline(h=10, lty=2); abline(h=90, lty=2); text(10, 100, "B", cex=2)
                                    # grows with turning point
N.max <- 90; a <- 5; b <- 0.5
N <- N.max / (1+e^(a - b*t))
plot(t, N, ylim=c(0,100), type="l", las=1, cex.lab=1.5,
     xlab="time [t]", ylab="stock [N]")
N.0 <- N.max / (1+e^a)
abline(h=N.max, lty=2); abline(h=N.0, lty=2); text(10, 100, "C", cex=2)

#########################################################################

                                                            # Figure 2.11

par(lwd=1.5, font.axis=2, bty="n", ps=12, cex.axis=1.3, mfrow=c(1,1)) 
x <- seq(0.5, 4.5, by=0.001)
f <- function(x) - 0.5*x^2 + 2*x + 2
y <- f(x)
plot(x,y, type="l", axes=TRUE, lwd=1.2, xlab=" ", ylab=" ", las=1,
    xlim=c(0,5), ylim=c(-1,5))
x1 <- seq(1.5, 3, by=0.1)
y1 <- f(x1)
polygon(c(1.5, x1, 3), c(0, y1, 0), density=5, lwd=0.7)
polygon(c(3, 3, 3.25, 3.25), c(0, f(3), f(3), 0))
polygon(c(3, 3, 3.25, 3.25), c(0, f(3.25), f(3.25), 0),angle=135, 
        lwd=0.7, density=10)
abline(h=0)
text(2.3, 2, "F(x)", cex=2, font=4)
text(1.5, -0.28, "a", cex=1.5, font=4)
text(3.25, -0.28, "b", cex=1.5, font=4)
text(3.7, 3.8, expression((b-3)*(f(3)-f(b))), cex=1.3, font=4)

#########################################################################

                                                          # Abschnitt 2.6
                                                   
library(combinat)                                         # Permutations
x <- c("a","b","c")   
permn(x)                                                  

#########################################################################

n <- 8                                         # products, faculty  
prod(1:n)

#########################################################################

n <- 20                                        # family tress
prod(1:(2*n -2)) / (2^(n-1)*prod(1:(n-1)))

#########################################################################

n <- 9; k <- 7                                 # binomial coefficient
choose(n, k)       

#########################################################################

combn(letters[1:5], 3)                         # combinations 

#########################################################################

choose(10, 3) * prod(1:3)                      # prizes

#########################################################################

choose(5+12-1, 12)                             # candies                   

#########################################################################

26^3 + 26^2 + 26                               # words 

########################################################################

sum(choose(10, 1:10))                          # equipments

########################################################################

                                               # multinomial coefficient

cards <- 52                                    # number of cards  

player <- 4                                    # number of Players  

c_play <- cards/player                         # number of cards per player      
prod(1:cards)/(prod(1:c_play)^player)

########################################################################